import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
const _excluded = ["getRootProps"];
import { useTabContext, getTabId, getPanelId } from '../TabsUnstyled';
import { useButton } from '../ButtonUnstyled';

const useTab = parameters => {
  var _getPanelId, _getTabId;

  const {
    value: valueProp,
    onChange,
    onClick,
    onFocus
  } = parameters;

  const _useButton = useButton(parameters),
        {
    getRootProps: getRootPropsButton
  } = _useButton,
        otherButtonProps = _objectWithoutPropertiesLoose(_useButton, _excluded);

  const context = useTabContext();

  if (context === null) {
    throw new Error('No TabContext provided');
  }

  const value = valueProp != null ? valueProp : 0;
  const selected = context.value === value;
  const selectionFollowsFocus = context.selectionFollowsFocus;
  const a11yAttributes = {
    role: 'tab',
    'aria-controls': (_getPanelId = getPanelId(context, value)) != null ? _getPanelId : undefined,
    id: (_getTabId = getTabId(context, value)) != null ? _getTabId : undefined,
    'aria-selected': selected,
    disabled: otherButtonProps.disabled
  };

  const createHandleFocus = otherHandlers => event => {
    var _otherHandlers$onFocu;

    (_otherHandlers$onFocu = otherHandlers.onFocus) == null ? void 0 : _otherHandlers$onFocu.call(otherHandlers, event);

    if (event.defaultPrevented) {
      return;
    }

    if (selectionFollowsFocus && !selected) {
      if (onChange) {
        onChange(event, value);
      }

      context.onSelected(event, value);
    }

    if (onFocus) {
      onFocus(event);
    }
  };

  const createHandleClick = otherHandlers => event => {
    var _otherHandlers$onClic;

    (_otherHandlers$onClic = otherHandlers.onClick) == null ? void 0 : _otherHandlers$onClic.call(otherHandlers, event);

    if (event.defaultPrevented) {
      return;
    }

    if (!selected) {
      if (onChange) {
        onChange(event, value);
      }

      context.onSelected(event, value);
    }

    if (onClick) {
      onClick(event);
    }
  };

  const getRootProps = (otherHandlers = {}) => {
    const buttonResolvedProps = getRootPropsButton(_extends({}, otherHandlers, {
      onClick: createHandleClick(otherHandlers),
      onFocus: createHandleFocus(otherHandlers)
    }));
    return _extends({}, buttonResolvedProps, a11yAttributes);
  };

  return _extends({
    getRootProps
  }, otherButtonProps, {
    selected
  });
};

export default useTab;