import React from 'react';
import { OverrideProps } from '@mui/types';
import { UseTabsListRootSlotProps } from './useTabsList.types';
import { SlotComponentProps } from '../utils';
interface TabsListUnstyledComponentsPropsOverrides {
}
export interface TabsListUnstyledOwnProps {
    /**
     * The content of the component.
     */
    children?: React.ReactNode;
    className?: string;
    /**
     * The components used for each slot inside the TabsList.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components?: {
        Root?: React.ElementType;
    };
    /**
     * The props used for each slot inside the TabsList.
     * @default {}
     */
    componentsProps?: {
        root?: SlotComponentProps<'div', TabsListUnstyledComponentsPropsOverrides, TabsListUnstyledOwnerState>;
    };
}
export interface TabsListUnstyledTypeMap<P = {}, D extends React.ElementType = 'div'> {
    props: P & TabsListUnstyledOwnProps;
    defaultComponent: D;
}
export declare type TabsListUnstyledProps<D extends React.ElementType = TabsListUnstyledTypeMap['defaultComponent'], P = {}> = OverrideProps<TabsListUnstyledTypeMap<P, D>, D> & {
    component?: D;
};
export declare type TabsListUnstyledOwnerState = TabsListUnstyledProps & {
    isRtl: boolean;
    orientation: 'horizontal' | 'vertical';
};
export declare type TabsListUnstyledRootSlotProps = UseTabsListRootSlotProps & {
    className?: string;
    ownerState: TabsListUnstyledOwnerState;
};
export {};
