var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toESM = (module2, isNodeMode) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", !isNodeMode && module2 && module2.__esModule ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);
var async_queue_exports = {};
__export(async_queue_exports, {
  AsyncQueueError: () => AsyncQueueError,
  default: () => async_queue_default
});
var import_base_error = __toESM(require("../../errors/base-error"));
var import_connection_error = __toESM(require("../../errors/connection-error"));
class AsyncQueueError extends import_base_error.default {
  constructor(message) {
    super(message);
    this.name = "SequelizeAsyncQueueError";
  }
}
class AsyncQueue {
  previous;
  closed;
  rejectCurrent;
  constructor() {
    this.previous = Promise.resolve();
    this.closed = false;
    this.rejectCurrent = () => {
    };
  }
  close() {
    this.closed = true;
    this.rejectCurrent(new import_connection_error.default(new AsyncQueueError("the connection was closed before this query could finish executing")));
  }
  async enqueue(asyncFunction) {
    return new Promise((resolve, reject) => {
      this.previous = this.previous.then(() => {
        this.rejectCurrent = reject;
        if (this.closed) {
          return reject(new import_connection_error.default(new AsyncQueueError("the connection was closed before this query could be executed")));
        }
        return asyncFunction().then(resolve, reject);
      });
    });
  }
}
var async_queue_default = AsyncQueue;
module.exports = __toCommonJS(async_queue_exports);
//# sourceMappingURL=async-queue.js.map
