var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toESM = (module2, isNodeMode) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", !isNodeMode && module2 && module2.__esModule ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);
var validation_error_exports = {};
__export(validation_error_exports, {
  ValidationErrorItem: () => ValidationErrorItem,
  ValidationErrorItemOrigin: () => ValidationErrorItemOrigin,
  ValidationErrorItemType: () => ValidationErrorItemType,
  default: () => validation_error_default
});
var import_base_error = __toESM(require("./base-error"));
var ValidationErrorItemType = /* @__PURE__ */ ((ValidationErrorItemType2) => {
  ValidationErrorItemType2["notnull violation"] = "CORE";
  ValidationErrorItemType2["string violation"] = "CORE";
  ValidationErrorItemType2["unique violation"] = "DB";
  ValidationErrorItemType2["validation error"] = "FUNCTION";
  return ValidationErrorItemType2;
})(ValidationErrorItemType || {});
var ValidationErrorItemOrigin = /* @__PURE__ */ ((ValidationErrorItemOrigin2) => {
  ValidationErrorItemOrigin2["CORE"] = "CORE";
  ValidationErrorItemOrigin2["DB"] = "DB";
  ValidationErrorItemOrigin2["FUNCTION"] = "FUNCTION";
  return ValidationErrorItemOrigin2;
})(ValidationErrorItemOrigin || {});
class ValidationErrorItem {
  static TypeStringMap = ValidationErrorItemType;
  static Origins = ValidationErrorItemOrigin;
  message;
  type;
  path;
  value;
  origin;
  instance;
  validatorKey;
  validatorName;
  validatorArgs;
  constructor(message, type, path, value, instance, validatorKey, fnName, fnArgs) {
    this.message = message || "";
    this.type = null;
    this.path = path || null;
    this.value = value !== void 0 ? value : null;
    this.origin = null;
    this.instance = instance || null;
    this.validatorKey = validatorKey || null;
    this.validatorName = fnName || null;
    this.validatorArgs = fnArgs || [];
    if (type) {
      if (this.isValidationErrorItemOrigin(type)) {
        this.origin = type;
      } else {
        const lowercaseType = this.normalizeString(type);
        const realType = ValidationErrorItemType[lowercaseType];
        if (realType && ValidationErrorItemOrigin[realType]) {
          this.origin = realType;
          this.type = type;
        }
      }
    }
  }
  isValidationErrorItemOrigin(origin) {
    return ValidationErrorItemOrigin[origin] !== void 0;
  }
  normalizeString(str) {
    return str.toLowerCase().trim();
  }
  getValidatorKey(useTypeAsNS, NSSeparator) {
    const useTANS = useTypeAsNS === void 0 || Boolean(useTypeAsNS);
    const NSSep = NSSeparator === void 0 ? "." : NSSeparator;
    const type = this.origin;
    const key = this.validatorKey || this.validatorName;
    const useNS = useTANS && type && ValidationErrorItemOrigin[type];
    if (useNS && (typeof NSSep !== "string" || NSSep.length === 0)) {
      throw new Error("Invalid namespace separator given, must be a non-empty string");
    }
    if (!(typeof key === "string" && key.length > 0)) {
      return "";
    }
    return (useNS ? [this.origin, key].join(NSSep) : key).toLowerCase().trim();
  }
}
class ValidationError extends import_base_error.default {
  errors;
  constructor(message, errors, options = {}) {
    super(message);
    this.name = "SequelizeValidationError";
    this.errors = errors || [];
    if (message) {
      this.message = message;
    } else if (this.errors.length > 0 && this.errors[0].message) {
      this.message = this.errors.map((err) => `${err.type || err.origin}: ${err.message}`).join(",\n");
    }
    if (options.stack) {
      this.stack = options.stack;
    }
  }
  get(path) {
    const out = [];
    for (const error of this.errors) {
      if (error.path === path) {
        out.push(error);
      }
    }
    return out;
  }
}
var validation_error_default = ValidationError;
module.exports = __toCommonJS(validation_error_exports);
//# sourceMappingURL=validation-error.js.map
