var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);
var join_sql_fragments_exports = {};
__export(join_sql_fragments_exports, {
  JoinSQLFragmentsError: () => JoinSQLFragmentsError,
  joinSQLFragments: () => joinSQLFragments
});
function doesNotWantLeadingSpace(str) {
  return /^[),;]/.test(str);
}
function doesNotWantTrailingSpace(str) {
  return str.endsWith("(");
}
function singleSpaceJoinHelper(parts) {
  return parts.reduce(({ skipNextLeadingSpace, result }, part) => {
    if (skipNextLeadingSpace || doesNotWantLeadingSpace(part)) {
      result += part.trim();
    } else {
      result += ` ${part.trim()}`;
    }
    return {
      skipNextLeadingSpace: doesNotWantTrailingSpace(part),
      result
    };
  }, {
    skipNextLeadingSpace: true,
    result: ""
  }).result;
}
function joinSQLFragments(array) {
  if (array.length === 0) {
    return "";
  }
  const truthyArray = array.filter((x) => Boolean(x));
  const flattenedArray = truthyArray.map((fragment) => {
    if (Array.isArray(fragment)) {
      return joinSQLFragments(fragment);
    }
    return fragment;
  });
  for (const fragment of flattenedArray) {
    if (fragment && typeof fragment !== "string") {
      throw new JoinSQLFragmentsError(flattenedArray, fragment, `Tried to construct a SQL string with a non-string, non-falsy fragment (${fragment}).`);
    }
  }
  const trimmedArray = flattenedArray.map((x) => x.trim());
  const nonEmptyStringArray = trimmedArray.filter((x) => x !== "");
  return singleSpaceJoinHelper(nonEmptyStringArray);
}
class JoinSQLFragmentsError extends TypeError {
  args;
  fragment;
  constructor(args, fragment, message) {
    super(message);
    this.args = args;
    this.fragment = fragment;
    this.name = "JoinSQLFragmentsError";
  }
}
module.exports = __toCommonJS(join_sql_fragments_exports);
//# sourceMappingURL=join-sql-fragments.js.map
