export declare type DialectSupports = {
    'DEFAULT': boolean;
    'DEFAULT VALUES': boolean;
    'VALUES ()': boolean;
    'LIMIT ON UPDATE': boolean;
    'ON DUPLICATE KEY': boolean;
    'ORDER NULLS': boolean;
    'UNION': boolean;
    'UNION ALL': boolean;
    'RIGHT JOIN': boolean;
    EXCEPTION: boolean;
    forShare?: 'LOCK IN SHARE MODE' | 'FOR SHARE' | undefined;
    lock: boolean;
    lockOf: boolean;
    lockKey: boolean;
    lockOuterJoinFailure: boolean;
    skipLocked: boolean;
    finalTable: boolean;
    returnValues: false | {
        output: boolean;
        returning: boolean;
    };
    autoIncrement: {
        identityInsert: boolean;
        defaultValue: boolean;
        update: boolean;
    };
    bulkDefault: boolean;
    schemas: boolean;
    transactions: boolean;
    settingIsolationLevelDuringTransaction: boolean;
    transactionOptions: {
        type: boolean;
    };
    migrations: boolean;
    upserts: boolean;
    inserts: {
        ignoreDuplicates: string;
        updateOnDuplicate: boolean | string;
        onConflictDoNothing: string;
        conflictFields: boolean;
    };
    constraints: {
        restrict: boolean;
        addConstraint: boolean;
        dropConstraint: boolean;
        unique: boolean;
        default: boolean;
        check: boolean;
        foreignKey: boolean;
        primaryKey: boolean;
        onUpdate: boolean;
    };
    index: {
        collate: boolean;
        length: boolean;
        parser: boolean;
        concurrently: boolean;
        type: boolean;
        using: boolean | number;
        functionBased: boolean;
        operator: boolean;
        where: boolean;
    };
    groupedLimit: boolean;
    indexViaAlter: boolean;
    JSON: boolean;
    JSONB: boolean;
    ARRAY: boolean;
    RANGE: boolean;
    NUMERIC: boolean;
    GEOMETRY: boolean;
    GEOGRAPHY: boolean;
    REGEXP: boolean;
    HSTORE: boolean;
    TSVECTOR: boolean;
    deferrableConstraints: boolean;
    tmpTableTrigger: boolean;
    indexHints: boolean;
    searchPath: boolean;
};
export declare abstract class AbstractDialect {
    /**
     * List of features this dialect supports.
     *
     * Important: Dialect implementations inherit these values.
     * When changing a default, ensure the implementations still properly declare which feature they support.
     */
    static readonly supports: DialectSupports;
    get supports(): DialectSupports;
    readonly queryGenerator: unknown;
}
